<?php
require_once('test-iquesta.php');
//require_once('md-cron.php');
exit();

if(!IP_ModeDev) {
    exit('Not found');
}

require_once(dirname(__FILE__) . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'vendor' . DIRECTORY_SEPARATOR . 'autoload.php');

use \App\IquestaToMyListingJob;

function mdPrintR($a, $e=true) {
    echo('<pre>');
    print_r($a);
    echo('</pre>');
    if($e)exit();
}

$iQuesta =  IquestaToMyListingJob::getInstance();

if(!isset($_GET['type'])) {
    $_GET['type'] = 'lastdata';
}

switch($_GET['type']) {
    case 'send':
        $file = '/var/www/vhosts/md-dev.fr/tobeerasmus-v2.md-dev.fr/tobeerasmus/web/wp-content/uploads/job-manager-uploads/tlchargement-de-cv/2018/12/sample.pdf';

        $datas = array(
            'email' => 'test@test.fr',
            'first_name' => 'Michaël',
            'last_name'  => 'DUBOIS',
            'offer_id'   => '292498',
        );
        $files = array();
        $files['file_1'] = fopen($file, 'r');
        $returnIQ = $iQuesta->iQuestaSendApplication($datas, $files);
        mdPrintR($returnIQ);
        break;
    case 'subjects':
        $returnIQ = $iQuesta->iQuestaSubjects();
        mdPrintR($returnIQ);
        break;
    case 'regions':
        $returnIQ = $iQuesta->iQuestaRegions();
        mdPrintR($returnIQ);
        break;
    case 'levels':
        $returnIQ = $iQuesta->iQuestaLevels();
        mdPrintR($returnIQ);
        break;
    case 'contracts':
        $returnIQ = $iQuesta->iQuestaContracts();
        mdPrintR($returnIQ);
        break;
    case 'lastdata':
        $iQuestaArgs = array('country_id' => 1, 'page' => 1, 'take' => 50);
        $returnIQ = $iQuesta->iQuestaOffers($iQuestaArgs);
        $maxPage = $returnIQ->last_page;
        $datas = $returnIQ->data;
        for($i=0; $i < count($datas); $i++) {
            unset($datas[$i]->description);
            unset($datas[$i]->company_name);
            unset($datas[$i]->contact);
            unset($datas[$i]->is_external_application);
            unset($datas[$i]->levels);
            unset($datas[$i]->reference);
            unset($datas[$i]->url);
            unset($datas[$i]->company);
            unset($datas[$i]->country);
        }
        mdPrintR($datas);
        break;
    case 'test-insert':
        // Liste des annonces actuelles
        $annoncesOnLine = array();
        $lastAnnonces = get_option( '_iQuestaLastAnnonces', false);
        //$lastAnnonces = unserialize($lastAnnonces);


        // Rechercher les informations
        $iQuestaArgs = array('country_id' => 1, 'page' => 1, 'take' => 2);
        mdLog('<br />');
        mdLog("##########################################################".'<br />');
        mdLog("## TOBEERASMUS - IMPORT IQUESTA  version 1.0 by MD 2020 ##".'<br />');
        mdLog("##########################################################".'<br />');
        $returnIQ = $iQuesta->iQuestaOffers($iQuestaArgs);

        $maxPage = $returnIQ->last_page;
        $datas = $returnIQ->data;

        $addUpdate = 0;
        $delete = 0;

        $maxPage = 1;
        // Traiter les données
        for($page=$maxPage; $page > 0; $page--) {
            $iQuestaArgs['page'] = $page;

            $returnIQ = $iQuesta->iQuestaOffers($iQuestaArgs);
            $datas = $returnIQ->data;
            mdLog("- Processing page " . $page . "/".$maxPage." : ");
            for($i=0; $i < count($datas); $i++) {
                $data = $datas[$i];
                $iQuesta->mdSave($data);
                $addUpdate++;
                $annoncesOnLine[] = $data->id;
            }
            mdLog("ok".'<br />');
        }

        $annoncesOnLine = serialize($annoncesOnLine);

        $tmp = get_option( '_iQuestaLastAnnonces', false);
        //if($tmp) {
            //add_option( '_iQuestaLastAnnonces', $annoncesOnLine);
            update_option( '_iQuestaLastAnnonces', $annoncesOnLine);
        //} else {
        //    $return = add_option( '_iQuestaLastAnnonces', $annoncesOnLine);
        //}
        $tmp = get_option( '_iQuestaLastAnnonces', false);
        foreach ($lastAnnonces AS $k => $lastAnnonce) {
            if(!in_array($lastAnnonce, $annoncesOnLine)) {
                $optionIQuestaId = '__iquesta_id_'. $lastAnnonce;
                $tmp = get_option($optionIQuestaId, false);
                if($tmp) {
                    $delete++;
                    wp_delete_post( $tmp, true );
                    delete_option($optionIQuestaId);
                }
            }
        }
        mdLog("- Added / Updated : " . $addUpdate.'<br />');
        mdLog("- Deleted : " . $delete.'<br />');
        mdLog("##########################################################".'<br />');
        mdLog('<br />');
        exit();
        break;
    default:
        exit('Type not found.');
        break;
}

function mdLog($message)
{
    print($message);
    flush();
    ob_flush();
}
