<div class="tab-content align-center" v-if="currentSubTab === 'other'">

	<expiry-rules inline-template>
		<div class="form-section expiry-rules">
			<h3>Expiration rules</h3>
			<p>Apart from the expiry date, you can have a listing expire when other conditions are met.</p>

			<div class="btn btn-secondary btn-block mb5 default-expiry">
				Expires when the expiry date is reached
			</div>

			<div v-for="rule in rules" class="btn btn-secondary btn-block mb5 rule" @click="removeRule(rule)">
				{{getRuleLabel(rule)}}
				<span>Delete rule</span>
			</div>

			<div class="select-wrapper text-right mt15">
				<select @change="addRule($event.target.value);$event.target.value='';">
					<option value="">
						{{ availableRules.length ? 'Add rule' : 'No additional rules available' }}
					</option>
					<option v-for="rule in availableRules" :value="rule.value">
						{{ rule.label }}
					</option>
				</select>
			</div>
		</div>
	</expiry-rules>

	<div class="form-section">
		<h3>Global listing type</h3>
		<p>
			Use this listing type in Explore page to display a global search form, that will
			look for results within all other listing types. You shouldn't have more than one global listing type.
			They also shouldn't be used in the Add Listing page or anywhere else besides the Explore page.
		</p>
		<label class="form-switch">
			<input type="checkbox" v-model="settings.global">
			<span class="switch-slider"></span>
		</label>
	</div>
</div>