<?php

namespace WPMailSMTP\Vendor;

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * The "filters" collection of methods.
 * Typical usage is:
 *  <code>
 *   $gmailService = new Google_Service_Gmail(...);
 *   $filters = $gmailService->filters;
 *  </code>
 */
class Google_Service_Gmail_Resource_UsersSettingsFilters extends \WPMailSMTP\Vendor\Google_Service_Resource
{
    /**
     * Creates a filter. (filters.create)
     *
     * @param string $userId User's email address. The special value "me" can be
     * used to indicate the authenticated user.
     * @param Google_Service_Gmail_Filter $postBody
     * @param array $optParams Optional parameters.
     * @return Google_Service_Gmail_Filter
     */
    public function create($userId, \WPMailSMTP\Vendor\Google_Service_Gmail_Filter $postBody, $optParams = array())
    {
        $params = array('userId' => $userId, 'postBody' => $postBody);
        $params = \array_merge($params, $optParams);
        return $this->call('create', array($params), "Google_Service_Gmail_Filter");
    }
    /**
     * Deletes a filter. (filters.delete)
     *
     * @param string $userId User's email address. The special value "me" can be
     * used to indicate the authenticated user.
     * @param string $id The ID of the filter to be deleted.
     * @param array $optParams Optional parameters.
     */
    public function delete($userId, $id, $optParams = array())
    {
        $params = array('userId' => $userId, 'id' => $id);
        $params = \array_merge($params, $optParams);
        return $this->call('delete', array($params));
    }
    /**
     * Gets a filter. (filters.get)
     *
     * @param string $userId User's email address. The special value "me" can be
     * used to indicate the authenticated user.
     * @param string $id The ID of the filter to be fetched.
     * @param array $optParams Optional parameters.
     * @return Google_Service_Gmail_Filter
     */
    public function get($userId, $id, $optParams = array())
    {
        $params = array('userId' => $userId, 'id' => $id);
        $params = \array_merge($params, $optParams);
        return $this->call('get', array($params), "Google_Service_Gmail_Filter");
    }
    /**
     * Lists the message filters of a Gmail user. (filters.listUsersSettingsFilters)
     *
     * @param string $userId User's email address. The special value "me" can be
     * used to indicate the authenticated user.
     * @param array $optParams Optional parameters.
     * @return Google_Service_Gmail_ListFiltersResponse
     */
    public function listUsersSettingsFilters($userId, $optParams = array())
    {
        $params = array('userId' => $userId);
        $params = \array_merge($params, $optParams);
        return $this->call('list', array($params), "Google_Service_Gmail_ListFiltersResponse");
    }
}
