<?php
namespace App;

use GuzzleHttp\Client;

/**
 *
 */
class Iquesta
{
    private $_client;
    private $_apiKey; // YOUR SECRET KEY
    private $_apiUrl;
    private $_debug;

    function __construct($debug = false)
    {
        $this->_apiUrl = 'https://api2.iquesta.com';
        $this->_apiKey = '6pKOoNxl0E9RvBiUWilz9DjX72VctUln';
        $this->_client = new Client();

        $this->_debug = $debug;
    }

    /**
     * See https://api2.iquesta.com/documentation
     */
    public function addUser($data)
    {
        try {
            return $this->_response($this->_post('/user', ['json' => $data]));
        } catch (\Exception $e) {
            return $this->_error($e);
        }
    }

    /**
     * See https://api2.iquesta.com/documentation
     */
    public function offer($offerId)
    {
        try {
            return $this->_response($this->_get('/offer/' . $offerId));
        } catch (\Exception $e) {
            return $this->_error($e);
        }

    }

    /**
     * See https://api2.iquesta.com/documentation
     */
    public function offers($data = [])
    {
        try {
            return $this->_response($this->_get('/offers', $data));
        } catch (\Exception $e) {
            return $this->_error($e);
        }

    }

    public function countries() {
        try {
            return $this->_response($this->_get('/countries'));
        } catch (\Exception $e) {
            return $this->_error($e);
        }
    }

    public function regions() {
        try {
            return $this->_response($this->_get('/regions'));
        } catch (\Exception $e) {
            return $this->_error($e);
        }
    }

    public function contracts() {
        try {
            return $this->_response($this->_get('/contracts'));
        } catch (\Exception $e) {
            return $this->_error($e);
        }
    }

    public function subjects() {
        try {
            return $this->_response($this->_get('/subjects'));
        } catch (\Exception $e) {
            return $this->_error($e);
        }
    }

    public function levels() {
        try {
            return $this->_response($this->_get('/levels'));
        } catch (\Exception $e) {
            return $this->_error($e);
        }
    }

    /**
     * Example :
     * $data = [
     *     'email'      => 'xavier@iquesta.com',
     *     'first_name' => 'xavier',
     *     'last_name'  => 'barbez',
     *     'offer_id'   => '298375',
     * ];
     *
     * $files = [
     *     'file_1' => fopen('/path/test.pdf', 'r'),
     *     'file_2' => fopen('/path/test-2.pdf', 'r')
     * ]
     */
    public function sendApplication($data, $files)
    {
        try {
            $multipart = [];

            foreach ($data as $key => $value) {
                $multipart[] = [
                    'name'     => $key,
                    'contents' => $value
                ];
            }

            foreach ($files as $key => $value) {
                $multipart[] = [
                    'name'     => $key,
                    'contents' => $value
                ];
            }

            return $this->_response($this->_post('/application', ['multipart' => $multipart]));
        } catch (\Exception $e) {
            return $this->_error($e);
        }
    }


    /**
     * See https://api2.iquesta.com/documentation
     */
    public function user($email)
    {
        try {
            return $this->_response($this->_get('/user', ['email' => $email]));
        } catch (\Exception $e) {
            return $this->_error($e);
        }
    }

    private function _error($e)
    {
        if ($e->getResponse()) {
            if ($this->_debug) {
                echo "<pre>";
                echo json_encode(json_decode($e->getResponse()->getBody()->getContents()), JSON_PRETTY_PRINT);
                echo "</pre>";
            }

            return json_decode($e->getResponse()->getBody()->getContents());
        }
    }

    private function _get($url, $data = [], $files = [])
    {
        return $this->_client->get($this->_apiUrl . $url, [
            'headers' => [
                'content-type'  => 'application/json',
                'Authorization' => 'Bearer ' . $this->_apiKey,
            ],
            'json' => $data,
        ]);
    }

    private function _post($url, $data = [], $files = [])
    {
        return $this->_client->post($this->_apiUrl . $url, [
            'headers' => [
                'Authorization' => 'Bearer ' . $this->_apiKey,
            ],
        ] + $data);
    }

    private function _response($response)
    {
        $statusCode = $response->getStatusCode();
        $return     = \json_decode($response->getBody()->getContents());

        if ($this->_debug) {
            echo "<pre>";
            echo json_encode($return , JSON_PRETTY_PRINT);
            echo "</pre>";
        }

        return $return;
    }
}
